/* Draws existing subbase onto cross sections */
/*************************************************************************
EXSUBBASE.X -- This criteria file is meant to draw existing subbase on any
project. All the user should have to do is define the appropriate symbology
for the edges of pavement and shoulders, as well as the appropriate pavement
and shoulder thicknesses for his/her project. You can also define the symbology
with which the subbase will be plotted.

Written By: Derricke Gray 
            GEOPAK Corp.
            850.942.4023
            derricke@geopak.com
            
This file should be run from side slope lt only or side slope rt only
            
ASSUMPTIONS: 

Assumes that each shoulder found has an associated edge of pavement

Assumes that edges of pavement will be found in pairs. If you have an odd
number of edges of pavement, you will get irregular results for that
particular cross section. An error message will be written onto the 
cross section if an odd number of pavement edges are found.
------------------------------------------------------------------------

Change Level Symbology for Pavement				NPY  1/24/01
Comment out hatching symbology				NPY  1/24/01
Add option to mark ex. edges of pavemnet			NPY  3/01/01
Change Level Symbology for Ex.Base				NPY  3/08/01
draw skip trace in off=0 for dx=300                   NPY  9/28/01  
Change to level names						NPY  4/18/06	

**************************************************************************/

/*************************************************************************
DEFINITIONS
**************************************************************************/

define_dgn "existing edge of pavement" \
dgn = ****.dgn \
lvname=RD_EX_Road

define "mark existing pavement" 0  
define "existing pavement thickness" 1.0


/*****************************************************************
This section of the file marks and labels each edge of pavement
*****************************************************************/

if p1 then
{
_d_stop = 0
_d_eop_intersection = 0
_d_eop_intersection_counter = 1
_d_mark_ex_pave = "mark existing pavement" 


draw skip trace in off=0 for dx=300
mark x900 y900

/*  mark  EXISTING EDGES OF PAVEMENT  X1 - X19 */

     if intersect dgn = "existing edge of pavement" then
          {
          _d_eop_intersection = 1
          _d_eop_intersection_counter = 1
          while intersect dgn = "existing edge of pavement"
               {
               draw skip dx = 1 dy = 0 to "existing edge of pavement"
               draw skip dx = 0 dy = 50
               draw skip dx = 0 dy = -1 to exist ground
               mark x[_d_eop_intersection_counter] y[_d_eop_intersection_counter]
               _d_eop_intersection_counter = _d_eop_intersection_counter + 1
               draw skip dx = (2 * tolerance) dy = 0
               }
          }
     _d_eop_intersection_counter = _d_eop_intersection_counter - 1
          

/*********************************************************************************
Check for odd number of edges of pavement and issue error message
**********************************************************************************/

_d_temp = _d_eop_intersection_counter / 2
_d_temp_int = INT(_d_temp)

if _d_temp > _d_temp_int then
  {
  draw skip to xpgl ypgl
  draw text char=^Irregular Pavement Found^ "~warning text symbology"
  _d_stop = 1
  }

}

/***************************************************************************************
This while loop loops over each of the edge of pavement pairs and draws the existing
pavement and shoulder subbase
****************************************************************************************/

if _d_stop = 0  then

   {
   _d_admin_counter = 1
   _d_median = 0
   while (_d_admin_counter < _d_eop_intersection_counter)

      {

      _d_global_counter = _d_admin_counter
      
/***************************************************************************
This section draws the existing pavement subbase
***************************************************************************/

 if p1 then
   {
   _d_rt_eop = _d_global_counter

   /* Draw Pavement */
   set plot parameters "~existing base symbology"
   draw skip to x[_d_rt_eop] y[_d_rt_eop]
   mark x601 y601
   mark x891 y891

   if _d_mark_ex_pave > 0 then
   /*  Mark Existing Pavement */
	{
	draw elevation text "~elevation text symbology"
	_s_ep_no = "EP"+ cvt_d_s0(_d_rt_eop)
	draw text value=_s_ep_no "~existing EOP text symbology"
	}  

   draw dx = 0 dy = -"existing pavement thickness"
   mark x300 y300
   draw trace out off = -"existing pavement thickness" to x[_d_rt_eop+1]
   mark x301 y301

   draw dx = 0 dy = 1 to existing ground
   /* save off mark points for subsequent use */
   draw skip to x[_d_rt_eop] y[_d_rt_eop]
   draw skip dx = 0 dy = -"existing pavement thickness"
   mark x702 y702
   mark x802 y802
   draw skip to x[_d_rt_eop+1] y[_d_rt_eop+1]
   mark x602 y602
   mark x892 y892

   If _d_mark_ex_pave > 0 then
   /*  Mark Existing Pavement */
	{
	draw elevation text "~elevation text symbology"
	_s_ep_no = "EP"+ cvt_d_s0(_d_rt_eop+1)
	draw text value=_s_ep_no "~existing EOP text symbology"
	}

   draw skip dx = 0 dy = -"existing pavement thickness"
   mark x701 y701
   mark x801 y801
set plot parameters
   lv = 571
   co = 166
   lc = 0
   wt = 0   

   /* DRAW HATCHING */
   draw skip to x301 y301
   mark x14 y14
   draw skip dx=-1 dy=1 to existing ground
   mark x15 y15
   while x15 <= x300
     {
       draw skip to x14 y14
       draw to x15 y15
       draw skip to x14 y14
       draw skip trace in off=-"existing pavement thickness" for dx=1.5
       mark x14 y14
       draw skip dx=-1 dy=1 to existing ground
       mark x15 y15
     }

   }  
         



/***************************************************************
Reset the counter and go to the next pair of eop's
/***************************************************************/
         
      _d_admin_counter = _d_admin_counter + 2
     }
   }



      







